﻿using System;
using System.Collections.Generic;
using System.Text;

using Diffusion.Progression.Web.Service;

namespace ListHumanResource
{

    sealed class Program
    {
        private static Record[] humanResources = null;

        static int Main(string[] args)
        {

            if (args.Length != 3)
                return PrintUsage();

            ProgressionWebService service = new ProgressionWebService();

            if (args[0].Equals("test"))
                service.Url = "http://test.progressionlive.com/server/ws/v1/ProgressionWebService";
            else if (args[0].Equals("demo"))
                service.Url = "http://demo.progressionlive.com/server/ws/v1/ProgressionWebService";
            else if (args[0].Equals("prod"))
                service.Url = "http://my.progressionlive.com/server/ws/v1/ProgressionWebService";
            else
                service.Url = args[0];

            Credentials credentials = new Credentials()
            {
                Username = args[1],
                Password = args[2]
            };

            try
            {
                humanResources = service.SearchRecords(credentials, RecordType.HUMAN_RESOURCE, "", new Property[0], null);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return PrintUsage();
            }
            if (humanResources == null)
                return PrintUsage();

            Console.WriteLine("HumanResources");
            foreach (HumanResource humanResource in humanResources)
            {
                Console.WriteLine(string.Format("\tHumanResource Id:{0} Label:'{1}'", humanResource.Id, humanResource.Label));
                Console.WriteLine(string.Format("\t\tProperties"));
                Property[] properties = humanResource.Properties;
                foreach (Property property in properties)
                    if (property.Value != null && !"".Equals(property.Value))
                        Console.WriteLine(string.Format("\t\t\tProperty Name:'{0}' Value:'{1}'", property.Name, property.Value));
                Console.WriteLine();
            }

            return 0;
        }

        private static int PrintUsage()
        {
            Console.WriteLine("Usage: ListHumanResource.exe [test|demo|prod] username password");
            return -1;
        }
    }
}
