﻿using System;
using System.Collections.Generic;
using System.Text;

using Diffusion.Progression.Web.Service;

namespace ShowStaticData 
{

    sealed class Program 
    {
        private static Record[] disponibilities = null;
        private static Record[] taskTypes = null;
        private static Record[] workflows = null;

        private static int Main(string[] args)
        {

            if (args.Length != 3)
                return PrintUsage();

            ProgressionWebService service = new ProgressionWebService();

            service.Url = "http://" + args[0] + ".progressionlive.com/server/ws/v1/ProgressionWebService";

            Credentials credentials = new Credentials()
            {
                Username = args[1],
                Password = args[2]
            };

            try
            {
                disponibilities = service.SearchRecords(credentials, RecordType.DISPONIBILITY, "removed IS NULL", null, null, null);
                taskTypes = service.SearchRecords(credentials, RecordType.TASK_TYPE, "", null, null, null);
                workflows = service.SearchRecords(credentials, RecordType.WORKFLOW, "", null, null, null);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                return PrintUsage();
            }
            if (disponibilities == null || taskTypes == null || workflows == null)
                return PrintUsage();

            Console.WriteLine("Disponibilities");
            foreach (Disponibility disponibility in disponibilities)
                Console.WriteLine(string.Format("\tDisponibility Id:{0} Label:'{1}'", disponibility.Id, disponibility.Label));
            Console.WriteLine();

            Console.WriteLine("TaskTypes");
            foreach (TaskType taskType in taskTypes)
            {
                Console.WriteLine(string.Format("\tTaskType Id:{0} CodePrefix:'{1}' Label:'{2}'", taskType.Id, taskType.CodePrefix, taskType.Label));
                if (taskType.TaskItemTypeRef != null)
                    Console.WriteLine(string.Format("\t\tTaskItemType Id:{0}", taskType.TaskItemTypeRef.Id));
                Workflow workflow = GetWorkflow(taskType.WorkflowRef.Id);
                Console.WriteLine(string.Format("\t\tWorkflow Id:{0} StartTransitionId:{1}", workflow.Id, workflow.StartTransitionRef.Id));
                Console.WriteLine(string.Format("\t\t\tWorkflowSteps"));
                foreach (WorkflowStep workflowStep in workflow.Steps)
                {
                    Console.WriteLine(string.Format("\t\t\t\tWorkflowStep Id:{0} Label:'{1}'", workflowStep.Id, workflowStep.StatusLabel));
                    Console.WriteLine(string.Format("\t\t\t\t\tWorkflowTransitions"));
                    foreach (WorkflowTransition workflowTransition in workflowStep.Transitions)
                    {
                        if (workflowTransition != null)
                            if (workflowTransition.ToStepRef != null)
                                Console.WriteLine(string.Format("\t\t\t\t\t\tWorkflowTransition Id:{0} ToStepId:{1} UserCanTransition:{2}", workflowTransition.Id, workflowTransition.ToStepRef.Id, workflowTransition.UserCanTransition));
                            else
                                Console.WriteLine(string.Format("\t\t\t\t\t\tWorkflowTransition Id:{0} UserCanTransition:{1}", workflowTransition.Id, workflowTransition.UserCanTransition));
                    }
                }
                Console.WriteLine(string.Format("\t\tPriorities"));
                foreach (TaskPriority taskPriority in taskType.Priorities)
                {
                    Console.WriteLine(string.Format("\t\t\tTaskPriority Id:{0} Label:'{1}'", taskPriority.Id, taskPriority.Label));
                }
                Console.WriteLine(string.Format("\t\tPropertyGroups"));
                foreach (PropertyGroup propertyGroup in taskType.PropertyGroups)
                {
                    Console.WriteLine(string.Format("\t\t\tPropertyGroup Id:{0} Label:'{1}'", propertyGroup.Id, propertyGroup.Label));
                    Console.WriteLine(string.Format("\t\t\t\tPropertyDefinitions"));
                    foreach (PropertyDefinition propertyDefinition in propertyGroup.PropertyDefinitions)
                        Console.WriteLine(string.Format("\t\t\t\t\tPropertyDefinition Id:{0} Label:'{1}' Name:'{2}'", propertyDefinition.Id, propertyDefinition.Label, propertyDefinition.Name));
                }
                Console.WriteLine();
            }

            return 0;
        }

        private static int PrintUsage() 
        {
            Console.WriteLine("Usage: ShowStaticData.exe [my|app] username password");
            return -1;
        }

        private static Workflow GetWorkflow(long id)
        {
            foreach (Workflow i in workflows)
                if (i.Id == id)
                    return i;
            return null;
        }
    }
}
