﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Diffusion.Progression.Web.Service;

namespace ChangeMyDispo
{
    public partial class DispoForm : Form
    {
        public DispoForm()
        {
            InitializeComponent();
        }

        private void DispoForm_Load(object sender, EventArgs e)
        {
            Login();
        }

        private void changeButton_Click(object sender, EventArgs e)
        {
            try
            {
                DisponibilityItem disponibilityItem = dispoListBox.SelectedItem as DisponibilityItem;
                if (disponibilityItem == null)
                    return;
                RecordRef disponibilityRef = new RecordRef()
                {
                    Type = RecordType.DISPONIBILITY,
                    Id = disponibilityItem.Disponibility.Id
                };
                Program.ProgressionWebService.UpdateMyDisponibility(Program.Credentials, disponibilityRef, DateTime.Now, true);
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Ërror", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void Login()
        {
            LoginForm loginForm = new LoginForm();
            DialogResult dialogResult = loginForm.ShowDialog();
            System.Diagnostics.Debug.WriteLine(dialogResult);
            try
            {
                Record[] disponibilities = Program.ProgressionWebService.SearchRecords(Program.Credentials, RecordType.DISPONIBILITY, "removed IS NULL", null, null);
                foreach (Disponibility disponibility in disponibilities)
                    dispoListBox.Items.Add(new DisponibilityItem() { Disponibility = disponibility });
            }
            catch (Exception exception)
            {
                MessageBox.Show(exception.Message, "Ërror", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
    }

    internal sealed class DisponibilityItem
    {
        public Disponibility Disponibility { get; set; }

        public override string ToString()
        {
            return Disponibility.Label;
        }
    }
}
